-- Investments Table for Tier-based Investment System
CREATE TABLE IF NOT EXISTS `investments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(45) NOT NULL,
  `tier_id` int(2) NOT NULL,
  `tier_name` varchar(20) NOT NULL,
  `amount` decimal(16,6) NOT NULL DEFAULT 0.000000,
  `coin_amount` decimal(16,6) DEFAULT NULL,
  `coin` varchar(10) DEFAULT NULL,
  `coin_price` decimal(16,6) DEFAULT NULL,
  `apy` decimal(5,2) NOT NULL DEFAULT 0.00,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `txnid` varchar(57) NOT NULL DEFAULT '',
  `maturity_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_username` (`username`),
  KEY `idx_status` (`status`),
  KEY `idx_tier_id` (`tier_id`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- Add investment tracking columns to users table if they don't exist
ALTER TABLE `users` 
ADD COLUMN IF NOT EXISTS `total_invested` decimal(16,6) DEFAULT 0.000000,
ADD COLUMN IF NOT EXISTS `active_investments` decimal(16,6) DEFAULT 0.000000;

-- Add coin columns to investments table if they don't exist (for existing installations)
ALTER TABLE `investments`
ADD COLUMN IF NOT EXISTS `coin_amount` decimal(16,6) DEFAULT NULL,
ADD COLUMN IF NOT EXISTS `coin` varchar(10) DEFAULT NULL,
ADD COLUMN IF NOT EXISTS `coin_price` decimal(16,6) DEFAULT NULL;

