<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");  // Allows access from any origin

// Your database connection details
$servername = "localhost";
$username = "coinfzbe_pro_user";
$password = "_xS89yo#g?Rv";
$dbname = "coinfzbe_vortexprp";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$data = json_decode(file_get_contents("php://input"), true);
// Retrieve data from the request
$usernamey = $data['username'];
$coin = $data['coin'];
$cointicker = $data['cointicker'];
$amount = $data['amount'];
$address = $data['address'];
$balance = $data['balance'];
$fee = $data['fee'];

$cointick = strtolower($cointicker);


function generateRandomString($length = 17) {
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= 'URI'.$characters[random_int(0, $charactersLength - 1)];
    }
    return $randomString;
}

$txin = generateRandomString(13);

// Determine transaction type from request (if provided), otherwise auto-detect
$transactionMode = isset($data['transaction_mode']) ? $data['transaction_mode'] : null; // 'send_to_user' or 'withdraw'
$origin = 'send'; // Default origin
$transactionType = 'Send';
$destination = $address;
$autoProcess = false; // Whether to automatically process the transaction

// If transaction_mode is explicitly set
if ($transactionMode === 'send_to_user') {
    // Send to user within platform - auto process
    $origin = 'send';
    $transactionType = 'Send';
    $autoProcess = true;
} elseif ($transactionMode === 'withdraw') {
    // Withdraw to external wallet - requires admin approval
    $origin = 'withdraw';
    $transactionType = 'Withdraw';
    $autoProcess = false;
} else {
    // Auto-detect based on address format (backward compatibility)
    // Check if address looks like an external wallet address (long alphanumeric string)
    if (strlen($address) > 30 && preg_match('/^[A-Za-z0-9]+$/', $address)) {
        $origin = 'withdraw';
        $transactionType = 'Withdraw';
        $autoProcess = false;
    } else {
        // Likely a username - auto process
        $autoProcess = true;
    }
}

// Escape variables to prevent SQL injection
$usernamey_escaped = $conn->real_escape_string($usernamey);
$destination_escaped = $conn->real_escape_string($destination);
$cointicker_escaped = $conn->real_escape_string($cointicker);
$coin_escaped = $conn->real_escape_string($coin);
$origin_escaped = $conn->real_escape_string($origin);
$transactionType_escaped = $conn->real_escape_string($transactionType);

// Determine initial status based on transaction type
$initialStatus = $autoProcess ? 'Completed' : 'pending';

// Save transaction to database FIRST - this should always happen
$sql = "INSERT INTO transactions (username, address, destination, amount, to_amount, status, type, cointicker, coin, txtype, txnid, fee) 
        VALUES ('$usernamey_escaped', 'useracc', '$destination_escaped', '$amount', '$amount', '$initialStatus', '$transactionType_escaped', '$cointicker_escaped', '$coin_escaped', '$origin_escaped', '$txin', '$fee')";

$transaction_result = $conn->query($sql);
$transaction_error = '';
$transaction_saved = false;

if ($transaction_result) {
    $transaction_saved = true;
    error_log("Transaction saved successfully: Username=$usernamey_escaped, Amount=$amount, Coin=$cointicker_escaped, Origin=$origin_escaped, TXNID=$txin");
} else {
    $transaction_error = "Transaction record failed: " . $conn->error;
    error_log($transaction_error . " | SQL: " . $sql);
    // Try to get more details about the error
    error_log("MySQL Error Number: " . $conn->errno);
}

// Update sender balance
$sql8 = "UPDATE users SET v_{$cointick}=v_{$cointick}-'$amount', v_urg=v_urg-'$fee', total_withdrawal=total_withdrawal+'$amount' WHERE username='$usernamey_escaped'";
$result = $conn->query($sql8);  

if (!$result) {
    error_log("Balance update failed: " . $conn->error);
    echo json_encode(array("error" => "Error updating balance. Please try again later: " . $conn->error));
    $conn->close();
    exit;
}

// If auto-processing (send to user), credit the receiver immediately
if ($autoProcess && $origin === 'send') {
    // Check if recipient is a username (not a wallet address)
    // Query users table to see if the address/username exists
    $recipient_check = $conn->real_escape_string($destination);
    $check_sql = "SELECT username FROM users WHERE username='$recipient_check' OR email='$recipient_check' LIMIT 1";
    $check_result = $conn->query($check_sql);
    
    if ($check_result && $check_result->num_rows > 0) {
        // Recipient is a user - credit their account
        $recipient_username = $check_result->fetch_assoc()['username'];
        $recipient_escaped = $conn->real_escape_string($recipient_username);
        
        // Credit receiver's balance
        $credit_sql = "UPDATE users SET v_{$cointick}=v_{$cointick}+'$amount' WHERE username='$recipient_escaped'";
        $credit_result = $conn->query($credit_sql);
        
        if ($credit_result) {
            // Create received transaction for recipient
            $txin_received = generateRandomString(13);
            $received_sql = "INSERT INTO transactions (username, address, destination, amount, to_amount, status, type, cointicker, coin, txtype, txnid, fee) 
                            VALUES ('$recipient_escaped', 'useracc', '$usernamey_escaped', '$amount', '$amount', 'Completed', 'Received', '$cointicker_escaped', '$coin_escaped', 'send', '$txin_received', '0')";
            $conn->query($received_sql);
            
            // Send notification to recipient
            require_once __DIR__ . '/notification_helper.php';
            $recipientUserId = getUserIdFromUsername($conn, $recipient_username);
            if ($recipientUserId) {
                sendNotification($recipientUserId, $recipient_username, [
                    'type' => 'transaction',
                    'title' => 'Coins Received',
                    'message' => "You received {$amount} {$cointicker} from {$usernamey}",
                    'data' => [
                        'type' => 'received',
                        'amount' => $amount,
                        'coin' => $cointicker,
                        'status' => 'completed',
                        'txnid' => $txin_received,
                        'from' => $usernamey,
                    ],
                    'timestamp' => date('c'),
                ]);
            }
            
            error_log("Auto-processed send: {$amount} {$cointicker} from {$usernamey} to {$recipient_username}");
        } else {
            error_log("Failed to credit recipient: " . $conn->error);
        }
    } else {
        // Recipient not found - treat as withdrawal
        error_log("Recipient not found, treating as withdrawal: {$destination}");
        $autoProcess = false;
        $origin = 'withdraw';
        $transactionType = 'Withdraw';
        // Update transaction status back to pending
        $update_sql = "UPDATE transactions SET status='pending', type='Withdraw', txtype='withdraw' WHERE txnid='$txin'";
        $conn->query($update_sql);
    }
}

// Save to payments table for withdrawals
if ($origin === 'withdraw') {
    $address_escaped = $conn->real_escape_string($address);
    $sql87 = "INSERT INTO payments (username, txid, status, value, fin, address, coin) VALUES ('$usernamey_escaped', 'Withdrawal', 'pending', '$amount', '0', '$address_escaped', '$cointicker_escaped')";
    $result87 = $conn->query($sql87);
    if (!$result87) {
        error_log("Payment record failed: " . $conn->error);
    }
}

// Verify transaction was actually saved by querying the database
if ($transaction_saved) {
    $verify_sql = "SELECT id FROM transactions WHERE txnid='$txin' AND username='$usernamey_escaped' LIMIT 1";
    $verify_result = $conn->query($verify_sql);
    if ($verify_result && $verify_result->num_rows > 0) {
        error_log("Transaction verified in database: TXNID=$txin, Username=$usernamey_escaped");
        
        // Send real-time notification
        require_once __DIR__ . '/notification_helper.php';
        $userId = getUserIdFromUsername($conn, $usernamey);
        if ($userId) {
            sendNotification($userId, $usernamey, [
                'type' => 'transaction',
                'title' => $transactionType === 'Withdraw' ? 'Withdrawal Processed' : 'Transfer Sent',
                'message' => "You {$transactionType} {$amount} {$cointicker} - pending",
                'data' => [
                    'type' => strtolower($origin),
                    'amount' => $amount,
                    'coin' => $cointicker,
                    'status' => 'pending',
                    'txnid' => $txin,
                    'address' => $address,
                ],
                'timestamp' => date('c'),
            ]);
        }
        
        echo json_encode(array("success"=>true, "message" => "Transaction request for ".$cointicker." successfully sent. Please check your wallet for your coins."));
    } else {
        error_log("WARNING: Transaction insert returned success but transaction not found in database. TXNID=$txin, Username=$usernamey_escaped");
        echo json_encode(array("success"=>true, "message" => "Transaction processed but verification failed. Please contact support.", "warning" => "Transaction verification failed"));
    }
} else {
    // Transaction insert failed but balance was updated - this is a critical issue
    error_log("CRITICAL: Transaction was NOT saved to database but balance was updated. Username: $usernamey_escaped, Amount: $amount, Coin: $cointicker_escaped, Error: $transaction_error");
    // Still return success since balance was updated, but log the error
    echo json_encode(array("success"=>true, "message" => "Transaction processed but there was an issue recording it. Please contact support.", "warning" => $transaction_error));
}

$conn->close();
?>
