<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection
$servername = "localhost";
$username = "coinfzbe_pro_user";
$password = "_xS89yo#g?Rv";
$dbname = "coinfzbe_vortexprp";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["success" => false, "error" => "Connection failed: " . $conn->connect_error]));
}

$data = json_decode(file_get_contents("php://input"), true);

if (!$data || !isset($data['username']) || !isset($data['email']) || !isset($data['code']) || !isset($data['new_pin'])) {
    echo json_encode(["success" => false, "error" => "All fields are required"]);
    $conn->close();
    exit;
}

$username = $conn->real_escape_string($data['username']);
$email = $conn->real_escape_string($data['email']);
$code = $conn->real_escape_string($data['code']);
$new_pin = $conn->real_escape_string($data['new_pin']);

// Validate PIN length
if (strlen($new_pin) < 4 || strlen($new_pin) > 6 || !ctype_digit($new_pin)) {
    echo json_encode(["success" => false, "error" => "PIN must be 4-6 digits"]);
    $conn->close();
    exit;
}

// Verify code
$sql = "SELECT id FROM pin_reset_codes 
        WHERE username = '$username' 
        AND email = '$email' 
        AND code = '$code' 
        AND expires_at > NOW() 
        AND used = 0
        ORDER BY created_at DESC 
        LIMIT 1";

$result = $conn->query($sql);

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "error" => "Invalid or expired verification code"]);
    $conn->close();
    exit;
}

// Mark code as used
$row = $result->fetch_assoc();
$code_id = $row['id'];
$conn->query("UPDATE pin_reset_codes SET used = 1 WHERE id = $code_id");

// Update user PIN
$sql = "UPDATE users SET pin = '$new_pin' WHERE username = '$username' AND email = '$email'";

if ($conn->query($sql)) {
    echo json_encode([
        "success" => true,
        "message" => "PIN reset successfully"
    ]);
} else {
    echo json_encode(["success" => false, "error" => "Failed to reset PIN"]);
}

$conn->close();
?>

