<?php
/**
 * Register push notification token for user
 */
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

require_once __DIR__ . '/../config/database.php';

$data = json_decode(file_get_contents("php://input"), true);

$username = $data['username'] ?? '';
$userId = $data['user_id'] ?? null;
$pushToken = $data['push_token'] ?? '';
$platform = $data['platform'] ?? 'unknown';

if (empty($username) || empty($pushToken)) {
    echo json_encode([
        "success" => false,
        "error" => "Missing required fields: username and push_token"
    ]);
    exit;
}

try {
    // Check if push_tokens table exists, create if not
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS push_tokens (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            username VARCHAR(100) NOT NULL,
            push_token TEXT NOT NULL,
            platform VARCHAR(20) NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            UNIQUE KEY unique_user_platform (user_id, platform),
            INDEX idx_user_id (user_id),
            INDEX idx_username (username)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");

    // Get user ID if not provided
    if (!$userId) {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ? OR email = ? LIMIT 1");
        $stmt->execute([$username, $username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($user) {
            $userId = $user['id'];
        } else {
            throw new Exception("User not found");
        }
    }

    // Insert or update push token
    $stmt = $pdo->prepare("
        INSERT INTO push_tokens (user_id, username, push_token, platform, updated_at)
        VALUES (?, ?, ?, ?, NOW())
        ON DUPLICATE KEY UPDATE
            push_token = VALUES(push_token),
            updated_at = NOW()
    ");
    $stmt->execute([$userId, $username, $pushToken, $platform]);

    echo json_encode([
        "success" => true,
        "message" => "Push token registered successfully"
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "error" => $e->getMessage()
    ]);
}
?>

