-- Migration script for OxaPay integration
-- Run this SQL to create the necessary table for storing OxaPay addresses

CREATE TABLE IF NOT EXISTS `oxapay_addresses` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `username` VARCHAR(256) NOT NULL,
  `coin_symbol` VARCHAR(10) NOT NULL,
  `address` VARCHAR(255) NOT NULL,
  `order_id` VARCHAR(255) DEFAULT NULL,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `unique_user_coin` (`username`, `coin_symbol`),
  INDEX `idx_username` (`username`),
  INDEX `idx_address` (`address`),
  INDEX `idx_coin_symbol` (`coin_symbol`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Optional: Add OxaPay address columns to users table for quick access
-- Uncomment these if you want to store addresses directly in users table

-- ALTER TABLE `users` 
-- ADD COLUMN IF NOT EXISTS `btcoxapay_address` VARCHAR(255) DEFAULT NULL AFTER `btcaddress`,
-- ADD COLUMN IF NOT EXISTS `ethoxapay_address` VARCHAR(255) DEFAULT NULL AFTER `ethaddress`,
-- ADD COLUMN IF NOT EXISTS `ltcoxapay_address` VARCHAR(255) DEFAULT NULL AFTER `ltcaddress`,
-- ADD COLUMN IF NOT EXISTS `bnboxapay_address` VARCHAR(255) DEFAULT NULL AFTER `bnbaddress`,
-- ADD COLUMN IF NOT EXISTS `trxoxapay_address` VARCHAR(255) DEFAULT NULL AFTER `trxaddress`,
-- ADD COLUMN IF NOT EXISTS `xrpoxapay_address` VARCHAR(255) DEFAULT NULL,
-- ADD COLUMN IF NOT EXISTS `dogeoxapay_address` VARCHAR(255) DEFAULT NULL,
-- ADD COLUMN IF NOT EXISTS `usdtoxapay_address` VARCHAR(255) DEFAULT NULL AFTER `usdtaddress`;

