<?php
/**
 * Send real-time notification to user via WebSocket
 * This endpoint is called from transaction processing scripts
 */
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

$data = json_decode(file_get_contents("php://input"), true);

$userId = $data['user_id'] ?? $data['userId'] ?? null;
$username = $data['username'] ?? null;
$notification = $data['notification'] ?? null;

if (!$userId || !$notification) {
    echo json_encode([
        "success" => false,
        "error" => "Missing required fields: user_id and notification"
    ]);
    exit;
}

// WebSocket server URL
$wsServerUrl = "http://localhost:8080/notify";

// Prepare notification data
$notificationData = [
    "userId" => intval($userId),
    "notification" => $notification
];

// Send notification to WebSocket server
$ch = curl_init($wsServerUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notificationData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    echo json_encode([
        "success" => true,
        "message" => "Notification sent"
    ]);
} else {
    echo json_encode([
        "success" => false,
        "error" => "Failed to send notification",
        "http_code" => $httpCode
    ]);
}
?>

