<?php
/**
 * Send real-time message to trade participants via WebSocket
 */
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

$data = json_decode(file_get_contents("php://input"), true);

$tradeId = $data['trade_id'] ?? $data['tradeId'] ?? null;
$message = $data['message'] ?? null;

if (!$tradeId || !$message) {
    echo json_encode([
        "success" => false,
        "error" => "Missing required fields: trade_id and message"
    ]);
    exit;
}

// WebSocket server URL
$wsServerUrl = "http://localhost:8080/notify-trade";

// Prepare message data
$messageData = [
    "tradeId" => intval($tradeId),
    "message" => $message
];

// Send message to WebSocket server
$ch = curl_init($wsServerUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($messageData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    echo json_encode([
        "success" => true,
        "message" => "Trade message sent"
    ]);
} else {
    echo json_encode([
        "success" => false,
        "error" => "Failed to send trade message",
        "http_code" => $httpCode
    ]);
}
?>

