<?php
/**
 * Helper function to send real-time notifications via WebSocket
 */

function sendNotification($userId, $username, $notification) {
    $wsServerUrl = "http://localhost:8080/notify";
    
    $data = [
        "userId" => intval($userId),
        "notification" => $notification
    ];
    
    $ch = curl_init($wsServerUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_TIMEOUT, 2); // 2 second timeout
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        error_log("Failed to send notification to user $userId: HTTP $httpCode");
    }
    
    return $httpCode === 200;
}

function sendTradeNotification($tradeId, $message) {
    $wsServerUrl = "http://localhost:8080/notify-trade";
    
    $data = [
        "tradeId" => intval($tradeId),
        "message" => $message
    ];
    
    $ch = curl_init($wsServerUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_TIMEOUT, 2);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        error_log("Failed to send trade notification for trade $tradeId: HTTP $httpCode");
    }
    
    return $httpCode === 200;
}

function getUserIdFromUsername($conn, $username) {
    $username_escaped = $conn->real_escape_string($username);
    $result = $conn->query("SELECT id FROM users WHERE username = '$username_escaped' OR email = '$username_escaped' LIMIT 1");
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row['id'];
    }
    return null;
}
?>

