<?php
// Set error handler to catch all errors
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    error_log("PHP Error [$errno]: $errstr in $errfile on line $errline");
    http_response_code(500);
    echo json_encode(array("error" => "Server error occurred", "details" => $errstr));
    exit;
});

// Set exception handler
set_exception_handler(function($exception) {
    error_log("PHP Exception: " . $exception->getMessage());
    http_response_code(500);
    echo json_encode(array("error" => "Server error occurred", "details" => $exception->getMessage()));
    exit;
});

// Handle shutdown errors
register_shutdown_function(function() {
    $error = error_get_last();
    if ($error !== NULL && in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
        error_log("PHP Fatal Error: " . $error['message']);
        http_response_code(500);
        echo json_encode(array("error" => "Fatal error occurred", "details" => $error['message']));
        exit;
    }
});

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection details
$servername = "localhost";
$username = "coinfzbe_pro_user";
$password = "_xS89yo#g?Rv";
$dbname = "coinfzbe_vortexprp";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    error_log("Database connection failed: " . $conn->connect_error);
    http_response_code(500);
    echo json_encode(array("error" => "Database connection failed", "details" => $conn->connect_error));
    exit;
}

try {
    // First, check if admins table exists and has the required columns
    $checkTable = $conn->query("SHOW TABLES LIKE 'admins'");
    if ($checkTable && $checkTable->num_rows > 0) {
        // Check if columns exist
        $checkColumns = $conn->query("SHOW COLUMNS FROM admins LIKE 'platform_coin_symbol'");
        if ($checkColumns && $checkColumns->num_rows > 0) {
            // SQL query to retrieve platform coin details from admins table
            $sql = "SELECT 
                platform_coin,
                platform_coin_symbol,
                platform_coin_url,
                platform_coin_contract_address,
                platform_coin_network,
                platform_coin_total_supply,
                platform_coin_price
            FROM admins 
            WHERE platform_coin_symbol IS NOT NULL AND platform_coin_symbol != ''
            LIMIT 1";

            $result = $conn->query($sql);
            
            if ($result === false) {
                error_log("Query error: " . $conn->error);
                throw new Exception("Query failed: " . $conn->error);
            }

            // Check if any data is retrieved
            if ($result && $result->num_rows > 0) {
                $row = $result->fetch_assoc();
                $conn->close();
                echo json_encode($row);
                exit;
            }
        }
    }
    
    // Fallback to settings table if admins table doesn't have the data
    $checkSettingsTable = $conn->query("SHOW TABLES LIKE 'settings'");
    if ($checkSettingsTable && $checkSettingsTable->num_rows > 0) {
        $checkSettingsColumns = $conn->query("SHOW COLUMNS FROM settings LIKE 'platform_coin_symbol'");
        if ($checkSettingsColumns && $checkSettingsColumns->num_rows > 0) {
            $fallbackSql = "SELECT 
                platform_coin,
                platform_coin_symbol,
                platform_coin_url,
                platform_coin_price,
                platform_coin_total_supply
            FROM settings 
            WHERE platform_coin_symbol IS NOT NULL AND platform_coin_symbol != ''
            LIMIT 1";
            
            $fallbackResult = $conn->query($fallbackSql);
            
            if ($fallbackResult === false) {
                error_log("Fallback query error: " . $conn->error);
                throw new Exception("Fallback query failed: " . $conn->error);
            }
            
            if ($fallbackResult && $fallbackResult->num_rows > 0) {
                $row = $fallbackResult->fetch_assoc();
                // Add null values for missing fields
                $row['platform_coin_contract_address'] = null;
                $row['platform_coin_network'] = null;
                $conn->close();
                echo json_encode($row);
                exit;
            }
        }
    }
    
    // No data found
    $conn->close();
    echo json_encode(array("error" => "Platform coin data not found"));
    
} catch (Exception $e) {
    error_log("Exception in get_platform_coin.php: " . $e->getMessage());
    if (isset($conn) && $conn) {
        $conn->close();
    }
    http_response_code(500);
    echo json_encode(array("error" => "Server error occurred", "details" => $e->getMessage()));
}
?>

