<?php
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

// require 'vendor/autoload.php';
// use Slim\Factory\AppFactory;
// use GuzzleHttp\Client;

// $app = AppFactory::create();
// $db = new PDO("mysql:host=localhost;dbname=payment_processor", "root", ""); // Update credentials
// $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// $app->get('/test', function ($request, $response) {
//     $response->getBody()->write(json_encode(['status' => 'Slim 4 is working']));
//     return $response->withHeader('Content-Type', 'application/json');
// });

// $app->post('/create-address', function ($request, $response) use ($db) {
//     try {
//         $data = json_decode($request->getBody()->getContents(), true);
//         $username = $data['username'] ?? '';
//         if (empty($username)) throw new Exception("Username is required");

//         $stmt = $db->prepare("SELECT wallet_address FROM users WHERE username = ?");
//         $stmt->execute([$username]);
//         if ($stmt->fetchColumn()) throw new Exception("Username already exists");

//         $client = new Client();
//         $res = $client->post('http://localhost:3001/generate-address');
//         $address = json_decode($res->getBody()->getContents(), true)['address'];

//         $stmt = $db->prepare("INSERT INTO users (username, wallet_address) VALUES (?, ?)");
//         $stmt->execute([$username, $address]);

//         $response->getBody()->write(json_encode(['address' => $address]));
//     } catch (Exception $e) {
//         $response = $response->withStatus(400);
//         $response->getBody()->write(json_encode(['error' => $e->getMessage()]));
//     }
//     return $response->withHeader('Content-Type', 'application/json');
// });

// $app->get('/monitor-deposits', function ($request, $response) use ($db) {
//     $client = new Client(['base_uri' => 'https://api.devnet.solana.com']);
//     $stmt = $db->query("SELECT id, wallet_address FROM users");
//     $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

//     $debugOutput = [];

//     foreach ($users as $user) {
//         $userId = $user['id'];
//         $address = $user['wallet_address'];

//         $stmt = $db->prepare("SELECT signature FROM deposits WHERE wallet_address = ?");
//         $stmt->execute([$address]);
//         $existingSignatures = $stmt->fetchAll(PDO::FETCH_COLUMN);

//         // Get token accounts owned by the user
//         try {
//             $ataRes = $client->post('/', [
//                 'json' => [
//                     "jsonrpc" => "2.0",
//                     "id" => 1,
//                     "method" => "getTokenAccountsByOwner",
//                     "params" => [
//                         $address,
//                         ["programId" => "TokenkegQfeZyiNwAJbNbGKpfXDfkWqJreN"],
//                         ["encoding" => "jsonParsed"]
//                     ]
//                 ]
//             ]);
//             $ataData = json_decode($ataRes->getBody()->getContents(), true);
//             $debugOutput[$address]['token_accounts'] = $ataData;
//             $tokenAccounts = $ataData['result']['value'] ?? [];
//         } catch (Exception $e) {
//             $tokenAccounts = [];
//             $debugOutput[$address]['token_accounts_error'] = $e->getMessage();
//         }

//         $ataAddresses = array_column($tokenAccounts, 'pubkey');
//         $addressesToCheck = array_merge([$address], $ataAddresses);

//         foreach ($addressesToCheck as $checkAddress) {
//             try {
//                 $sigRes = $client->post('/', [
//                     'json' => [
//                         "jsonrpc" => "2.0",
//                         "id" => 1,
//                         "method" => "getSignaturesForAddress",
//                         "params" => [$checkAddress, ["limit" => 10]]
//                     ]
//                 ]);
//                 $sigData = json_decode($sigRes->getBody()->getContents(), true);
//                 $debugOutput[$checkAddress]['signatures'] = $sigData;
//                 $signatures = $sigData['result'] ?? [];
//             } catch (Exception $e) {
//                 $signatures = [];
//                 $debugOutput[$checkAddress]['signatures_error'] = $e->getMessage();
//             }

//             foreach ($signatures as $sigData) {
//                 $signature = $sigData['signature'];
//                 if (in_array($signature, $existingSignatures)) continue;

//                 $txRes = $client->post('/', [
//                     'json' => [
//                         "jsonrpc" => "2.0",
//                         "id" => 1,
//                         "method" => "getTransaction",
//                         "params" => [$signature, "jsonParsed"]
//                     ]
//                 ]);
//                 $tx = json_decode($txRes->getBody()->getContents(), true)['result'];

//                 if ($tx) {
//                     $amount = null;
//                     $tokenMint = null;
//                     $tokenName = 'Unknown';

//                     // SOL transfer (wallet address only)
//                     if ($checkAddress === $address) {
//                         $accountIndex = array_search($address, array_column($tx['transaction']['message']['accountKeys'], 'pubkey'));
//                         if ($accountIndex !== false && $tx['meta']['postBalances'][$accountIndex] > $tx['meta']['preBalances'][$accountIndex]) {
//                             $amount = ($tx['meta']['postBalances'][$accountIndex] - $tx['meta']['preBalances'][$accountIndex]) / 1e9;
//                             $tokenMint = null;
//                             $tokenName = 'SOL';
//                         }
//                     }

//                     // SPL token transfer (ATA addresses)
//                     if (in_array($checkAddress, $ataAddresses) && isset($tx['meta']['postTokenBalances'])) {
//                         foreach ($tx['meta']['postTokenBalances'] as $balance) {
//                             if ($balance['accountIndex'] === array_search($checkAddress, array_column($tx['transaction']['message']['accountKeys'], 'pubkey'))) {
//                                 $preBalance = 0;
//                                 foreach ($tx['meta']['preTokenBalances'] as $pre) {
//                                     if ($pre['accountIndex'] === $balance['accountIndex'] && $pre['mint'] === $balance['mint']) {
//                                         $preBalance = $pre['uiTokenAmount']['uiAmount'] ?? 0;
//                                         break;
//                                     }
//                                 }
//                                 $postBalance = $balance['uiTokenAmount']['uiAmount'] ?? 0;
//                                 if ($postBalance > $preBalance) {
//                                     $amount = $postBalance - $preBalance;
//                                     $tokenMint = $balance['mint'];
//                                     $tokenNames = [
//                                         'EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v' => 'USDC',
//                                         'So11111111111111111111111111111111111111112' => 'SOL' // Wrapped SOL
//                                     ];
//                                     $tokenName = $tokenNames[$tokenMint] ?? 'Unknown';
//                                     break;
//                                 }
//                             }
//                         }
//                     }

//                     if ($amount !== null) {
//                         $stmt = $db->prepare(
//                             "INSERT INTO deposits (user_id, wallet_address, amount, token_mint, token_name, timestamp, signature) 
//                             VALUES (?, ?, ?, ?, ?, ?, ?)"
//                         );
//                         $stmt->execute([$userId, $address, $amount, $tokenMint, $tokenName, date('Y-m-d H:i:s', $tx['blockTime']), $signature]);
//                     }
//                 }
//             }
//         }
//     }

//     $response->getBody()->write(json_encode(['status' => 'Monitoring complete', 'debug' => $debugOutput]));
//     return $response->withHeader('Content-Type', 'application/json');
// });

// $app->run();


error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'vendor/autoload.php';
use Slim\Factory\AppFactory;
use GuzzleHttp\Client;

$app = AppFactory::create();
$db = new PDO("mysql:host=localhost;dbname=payment_processor", "root", ""); // Update credentials
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$app->get('/test', function ($request, $response) {
    $response->getBody()->write(json_encode(['status' => 'Slim 4 is working']));
    return $response->withHeader('Content-Type', 'application/json');
});

$app->post('/create-address', function ($request, $response) use ($db) {
    try {
        $data = json_decode($request->getBody()->getContents(), true);
        $username = $data['username'] ?? '';
        if (empty($username)) throw new Exception("Username is required");

        $stmt = $db->prepare("SELECT wallet_address FROM users WHERE username = ?");
        $stmt->execute([$username]);
        if ($stmt->fetchColumn()) throw new Exception("Username already exists");

        $client = new Client();
        $res = $client->post('http://localhost:3001/generate-address');
        $address = json_decode($res->getBody()->getContents(), true)['address'];

        $stmt = $db->prepare("INSERT INTO users (username, wallet_address) VALUES (?, ?)");
        $stmt->execute([$username, $address]);

        $response->getBody()->write(json_encode(['address' => $address]));
    } catch (Exception $e) {
        $response = $response->withStatus(400);
        $response->getBody()->write(json_encode(['error' => $e->getMessage()]));
    }
    return $response->withHeader('Content-Type', 'application/json');
});

// Monitor SOL deposits
$app->get('/monitor-deposits', function ($request, $response) use ($db) {
    $client = new Client(['base_uri' => 'https://api.devnet.solana.com']);
    $stmt = $db->query("SELECT id, wallet_address FROM users");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $debugOutput = [];

    foreach ($users as $user) {
        $userId = $user['id'];
        $address = $user['wallet_address'];

        $stmt = $db->prepare("SELECT signature FROM deposits WHERE wallet_address = ?");
        $stmt->execute([$address]);
        $existingSignatures = $stmt->fetchAll(PDO::FETCH_COLUMN);

        try {
            $sigRes = $client->post('/', [
                'json' => [
                    "jsonrpc" => "2.0",
                    "id" => 1,
                    "method" => "getSignaturesForAddress",
                    "params" => [$address, ["limit" => 10]]
                ]
            ]);
            $sigData = json_decode($sigRes->getBody()->getContents(), true);
            $debugOutput[$address]['signatures'] = $sigData;
            $signatures = $sigData['result'] ?? [];
        } catch (Exception $e) {
            $signatures = [];
            $debugOutput[$address]['signatures_error'] = $e->getMessage();
        }

        foreach ($signatures as $sigData) {
            $signature = $sigData['signature'];
            if (in_array($signature, $existingSignatures)) continue;

            $txRes = $client->post('/', [
                'json' => [
                    "jsonrpc" => "2.0",
                    "id" => 1,
                    "method" => "getTransaction",
                    "params" => [$signature, "jsonParsed"]
                ]
            ]);
            $tx = json_decode($txRes->getBody()->getContents(), true)['result'];

            if ($tx) {
                $amount = null;
                $tokenMint = null;
                $tokenName = 'SOL';

                $accountIndex = array_search($address, array_column($tx['transaction']['message']['accountKeys'], 'pubkey'));
                if ($accountIndex !== false && $tx['meta']['postBalances'][$accountIndex] > $tx['meta']['preBalances'][$accountIndex]) {
                    $amount = ($tx['meta']['postBalances'][$accountIndex] - $tx['meta']['preBalances'][$accountIndex]) / 1e9;
                }

                if ($amount !== null) {
                    $stmt = $db->prepare(
                        "INSERT INTO deposits (user_id, wallet_address, amount, token_mint, token_name, timestamp, signature) 
                        VALUES (?, ?, ?, ?, ?, ?, ?)"
                    );
                    $stmt->execute([$userId, $address, $amount, $tokenMint, $tokenName, date('Y-m-d H:i:s', $tx['blockTime']), $signature]);
                }
            }
        }
    }

    $response->getBody()->write(json_encode(['status' => 'SOL monitoring complete', 'debug' => $debugOutput]));
    return $response->withHeader('Content-Type', 'application/json');
});

// Monitor SPL token deposits
$app->get('/monitor-spl-deposits', function ($request, $response) use ($db) {
    $client = new Client(['base_uri' => 'https://api.devnet.solana.com']);
    $stmt = $db->query("SELECT id, wallet_address FROM users");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $debugOutput = [];

    foreach ($users as $user) {
        $userId = $user['id'];
        $address = $user['wallet_address'];

        $stmt = $db->prepare("SELECT signature FROM deposits WHERE wallet_address = ?");
        $stmt->execute([$address]);
        $existingSignatures = $stmt->fetchAll(PDO::FETCH_COLUMN);

        // Get token accounts
        try {
            $ataRes = $client->post('/', [
                'json' => [
                    "jsonrpc" => "2.0",
                    "id" => 1,
                    "method" => "getTokenAccountsByOwner",
                    "params" => [
                        $address,
                        ["programId" => "TokenkegQfeZyiNwAJbNbGKpfXDfkWqJreN"],
                        "jsonParsed"
                    ]
                ]
            ]);
            $ataData = json_decode($ataRes->getBody()->getContents(), true);
            $debugOutput[$address]['token_accounts'] = $ataData;
            $tokenAccounts = $ataData['result']['value'] ?? [];
        } catch (Exception $e) {
            $tokenAccounts = [];
            $debugOutput[$address]['token_accounts_error'] = $e->getMessage();
        }

        $ataAddresses = array_column($tokenAccounts, 'pubkey');

        foreach ($ataAddresses as $ataAddress) {
            try {
                $sigRes = $client->post('/', [
                    'json' => [
                        "jsonrpc" => "2.0",
                        "id" => 1,
                        "method" => "getSignaturesForAddress",
                        "params" => [$ataAddress, ["limit" => 10]]
                    ]
                ]);
                $sigData = json_decode($sigRes->getBody()->getContents(), true);
                $debugOutput[$ataAddress]['signatures'] = $sigData;
                $signatures = $sigData['result'] ?? [];
            } catch (Exception $e) {
                $signatures = [];
                $debugOutput[$ataAddress]['signatures_error'] = $e->getMessage();
            }

            foreach ($signatures as $sigData) {
                $signature = $sigData['signature'];
                if (in_array($signature, $existingSignatures)) continue;

                $txRes = $client->post('/', [
                    'json' => [
                        "jsonrpc" => "2.0",
                        "id" => 1,
                        "method" => "getTransaction",
                        "params" => [$signature, "jsonParsed"]
                    ]
                ]);
                $tx = json_decode($txRes->getBody()->getContents(), true)['result'];

                if ($tx) {
                    $amount = null;
                    $tokenMint = null;
                    $tokenName = 'Unknown';

                    if (isset($tx['meta']['postTokenBalances'])) {
                        foreach ($tx['meta']['postTokenBalances'] as $balance) {
                            if ($balance['accountIndex'] === array_search($ataAddress, array_column($tx['transaction']['message']['accountKeys'], 'pubkey'))) {
                                $preBalance = 0;
                                foreach ($tx['meta']['preTokenBalances'] as $pre) {
                                    if ($pre['accountIndex'] === $balance['accountIndex'] && $pre['mint'] === $balance['mint']) {
                                        $preBalance = $pre['uiTokenAmount']['uiAmount'] ?? 0;
                                        break;
                                    }
                                }
                                $postBalance = $balance['uiTokenAmount']['uiAmount'] ?? 0;
                                if ($postBalance > $preBalance) {
                                    $amount = $postBalance - $preBalance;
                                    $tokenMint = $balance['mint'];
                                    $tokenNames = [
                                        'EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v' => 'USDC',
                                        'So11111111111111111111111111111111111111112' => 'SOL' // Wrapped SOL
                                    ];
                                    $tokenName = $tokenNames[$tokenMint] ?? 'Unknown';
                                    break;
                                }
                            }
                        }
                    }

                    if ($amount !== null) {
                        $stmt = $db->prepare(
                            "INSERT INTO deposits (user_id, wallet_address, amount, token_mint, token_name, timestamp, signature) 
                            VALUES (?, ?, ?, ?, ?, ?, ?)"
                        );
                        $stmt->execute([$userId, $address, $amount, $tokenMint, $tokenName, date('Y-m-d H:i:s', $tx['blockTime']), $signature]);
                    }
                }
            }
        }
    }

    $response->getBody()->write(json_encode(['status' => 'SPL monitoring complete', 'debug' => $debugOutput]));
    return $response->withHeader('Content-Type', 'application/json');
});

$app->run();