-- Migration script to add 'pending' and 'waiting_seller' status values to trades table
-- This allows trades to be created in a pending state before seller accepts and funds escrow

ALTER TABLE trades 
MODIFY COLUMN status ENUM('pending', 'waiting_seller', 'active', 'completed', 'cancelled', 'disputed') DEFAULT 'pending';

-- Update any existing 'active' trades that should be 'pending' if they haven't been accepted yet
-- (This is optional - only run if you want to update existing data)
-- UPDATE trades SET status = 'pending' WHERE status = 'active' AND seller_payment_details IS NULL;

SELECT 'Trades status ENUM updated successfully! Added: pending, waiting_seller' as Status;

