<?php
/**
 * Run Order Book Migration
 * Creates the orders and exchange_trades tables
 */

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

$servername = "localhost";
$username = "coinfzbe_pro_user";
$password = "_xS89yo#g?Rv";
$dbname = "coinfzbe_vortexprp";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $conn->connect_error]));
}

// Read SQL file
$sqlFile = __DIR__ . '/create_orderbook_tables.sql';
if (!file_exists($sqlFile)) {
    die(json_encode(["error" => "SQL file not found: $sqlFile"]));
}

$sql = file_get_contents($sqlFile);

// Execute SQL (split by semicolon to handle multiple statements)
$statements = array_filter(array_map('trim', explode(';', $sql)));

$errors = [];
$success = [];

foreach ($statements as $statement) {
    if (empty($statement) || strpos($statement, '--') === 0) {
        continue;
    }
    
    if ($conn->query($statement)) {
        $success[] = "Executed: " . substr($statement, 0, 50) . "...";
    } else {
        $errors[] = "Error: " . $conn->error . " in: " . substr($statement, 0, 50) . "...";
    }
}

if (empty($errors)) {
    echo json_encode([
        "success" => true,
        "message" => "Order book tables created successfully",
        "executed" => count($success)
    ]);
} else {
    echo json_encode([
        "success" => false,
        "errors" => $errors,
        "executed" => count($success)
    ]);
}

$conn->close();
?>

