<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$conn = new mysqli("localhost","coinfzbe_pro_user", "_xS89yo#g?Rv", "coinfzbe_vortexprp");
if ($conn->connect_error) {
    echo json_encode(["success" => false, "error" => "DB connection failed"]);
    exit;
}

// Connection for transactions table (vortex database)
$transactions_conn = new mysqli("localhost","coinfzbe_pro_user", "_xS89yo#g?Rv", "coinfzbe_vortexprp");
if ($transactions_conn->connect_error) {
    // Log error but don't fail - transactions saving is secondary
    error_log("Transactions DB connection failed: " . $transactions_conn->connect_error);
}

$data = json_decode(file_get_contents("php://input"), true);
$trade_id = isset($data['trade_id']) ? intval($data['trade_id']) : (isset($_POST['trade_id']) ? intval($_POST['trade_id']) : 0);
$seller_id = isset($data['seller_id']) ? intval($data['seller_id']) : (isset($_POST['seller_id']) ? intval($_POST['seller_id']) : 0);

if (!$trade_id || !$seller_id) {
    echo json_encode(["success" => false, "error" => "Missing required fields"]);
    exit;
}

// Get trade with listing to get coin
$stmt = $conn->prepare("
    SELECT t.*, l.coin, l.seller_id as listing_seller_id
    FROM trades t
    JOIN listings l ON t.listing_id = l.id
    WHERE t.id = ? AND l.seller_id = ?
");
$stmt->bind_param("ii", $trade_id, $seller_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "error" => "Trade not found or unauthorized"]);
    exit;
}

$trade = $result->fetch_assoc();

if ($trade['status'] !== 'active') {
    echo json_encode(["success" => false, "error" => "Trade is not active"]);
    exit;
}

$buyer_id = intval($trade['buyer_id']);
$amount = floatval($trade['amount']);
$coin = strtolower($trade['coin']);

// Use coin balance (v_btc, v_eth, etc.)
$balance_key = "v_{$coin}";

// Start transaction
$conn->begin_transaction();

try {
    // Get buyer and seller usernames for transaction records
    $stmt = $conn->prepare("SELECT username FROM users WHERE id = ?");
    $stmt->bind_param("i", $buyer_id);
    $stmt->execute();
    $buyer_result = $stmt->get_result();
    $buyer_user = $buyer_result->fetch_assoc();
    $buyer_username = $buyer_user['username'] ?? '';

    $stmt = $conn->prepare("SELECT username FROM users WHERE id = ?");
    $stmt->bind_param("i", $seller_id);
    $stmt->execute();
    $seller_result = $stmt->get_result();
    $seller_user = $seller_result->fetch_assoc();
    $seller_username = $seller_user['username'] ?? '';

    // Generate transaction IDs
    function generateRandomString($length = 17) {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= 'URI'.$characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    $txnid_buyer = generateRandomString(13);
    $txnid_seller = generateRandomString(13);

    // Transfer from seller to buyer (release escrow)
    // Note: Using direct query for dynamic column names (coin is whitelisted, amount is validated)
    $amount_escaped = $conn->real_escape_string($amount);
    $buyer_id_escaped = intval($buyer_id); // Already validated as integer
    $update_query = "UPDATE users SET `{$balance_key}` = `{$balance_key}` + {$amount_escaped} WHERE id = {$buyer_id_escaped}";
    
    if (!$conn->query($update_query)) {
        throw new Exception("Failed to update buyer balance: " . $conn->error);
    }
    
    // Verify the update was successful
    $verify_query = "SELECT `{$balance_key}` FROM users WHERE id = {$buyer_id_escaped}";
    $verify_result = $conn->query($verify_query);
    if ($verify_result) {
        $verify_data = $verify_result->fetch_assoc();
        $new_balance = floatval($verify_data[$balance_key] ?? 0);
        error_log("Balance updated - Buyer ID: {$buyer_id_escaped}, Coin: {$coin}, New Balance: {$new_balance}");
    }

    // Save transaction to transactions table - Buyer receives
    if ($transactions_conn && !$transactions_conn->connect_error) {
        try {
            $coin_upper = strtoupper($trade['coin']);
            $stmt_tx = $transactions_conn->prepare("
                INSERT INTO transactions (username, address, destination, amount, to_amount, status, type, coin, cointicker, txtype, txnid, fee)
                VALUES (?, 'p2p', ?, ?, ?, 'Completed', 'Received', ?, ?, 'p2p', ?, '0.00000')
            ");
            if ($stmt_tx) {
                $destination = $seller_username;
                // Parameters: username(s), destination(s), amount(d), to_amount(d), coin(s), cointicker(s), txnid(s) = 7 params
                // Format string: sddssss = 7 characters (not 6!)
                $stmt_tx->bind_param("sddssss", $buyer_username, $destination, $amount, $amount, $trade['coin'], $coin_upper, $txnid_buyer);
                if (!$stmt_tx->execute()) {
                    error_log("Warning: Failed to save buyer transaction record: " . $stmt_tx->error);
                }
                $stmt_tx->close();
            }

            // Save transaction to transactions table - Seller completes sale
            $stmt_tx = $transactions_conn->prepare("
                INSERT INTO transactions (username, address, destination, amount, to_amount, status, type, coin, cointicker, txtype, txnid, fee)
                VALUES (?, 'p2p', ?, ?, ?, 'Completed', 'Send', ?, ?, 'p2p', ?, '0.00000')
            ");
            if ($stmt_tx) {
                $destination = $buyer_username;
                // Parameters: username(s), destination(s), amount(d), to_amount(d), coin(s), cointicker(s), txnid(s) = 7 params
                // Format string: sddssss = 7 characters (not 6!)
                $stmt_tx->bind_param("sddssss", $seller_username, $destination, $amount, $amount, $trade['coin'], $coin_upper, $txnid_seller);
                if (!$stmt_tx->execute()) {
                    error_log("Warning: Failed to save seller transaction record: " . $stmt_tx->error);
                }
                $stmt_tx->close();
            }
        } catch (Exception $tx_error) {
            // Log but don't fail - transaction saving is secondary
            error_log("Warning: Transaction record save failed (non-fatal): " . $tx_error->getMessage());
        }
    }

    // Update trade status
    $stmt = $conn->prepare("UPDATE trades SET status = 'completed', completed_at = NOW() WHERE id = ?");
    $stmt->bind_param("i", $trade_id);
    $stmt->execute();

    $conn->commit();
    
    // Send real-time notifications (wrap in try-catch so they don't fail the request)
    try {
        $notification_file = __DIR__ . '/../crispapi/notification_helper.php';
        if (file_exists($notification_file)) {
            require_once $notification_file;
            
            // Notify buyer
            if (function_exists('sendNotification') && $buyer_id && $buyer_username) {
                sendNotification($buyer_id, $buyer_username, [
                    'type' => 'trade_update',
                    'title' => 'Trade Completed',
                    'message' => "Funds have been released to you",
                    'data' => [
                        'tradeId' => $trade_id,
                        'status' => 'completed',
                        'type' => 'p2p',
                        'amount' => $amount,
                        'coin' => $trade['coin'],
                    ],
                    'timestamp' => date('c'),
                ]);
            }
            
            // Notify seller
            if (function_exists('sendNotification') && $seller_id && $seller_username) {
                sendNotification($seller_id, $seller_username, [
                    'type' => 'trade_update',
                    'title' => 'Trade Completed',
                    'message' => "You have released funds to the buyer",
                    'data' => [
                        'tradeId' => $trade_id,
                        'status' => 'completed',
                        'type' => 'p2p',
                        'amount' => $amount,
                        'coin' => $trade['coin'],
                    ],
                    'timestamp' => date('c'),
                ]);
            }
            
            // Send trade message update
            if (function_exists('sendTradeNotification')) {
                sendTradeNotification($trade_id, [
                    'type' => 'trade_update',
                    'trade_id' => $trade_id,
                    'status' => 'completed',
                    'message' => 'Trade has been completed and funds released',
                ]);
            }
        }
    } catch (Exception $notif_error) {
        // Log notification error but don't fail the request
        error_log("Notification error (non-fatal): " . $notif_error->getMessage());
    }
    
    echo json_encode(["success" => true, "message" => "Funds released to buyer"]);
} catch (Exception $e) {
    $conn->rollback();
    error_log("Release escrow error: " . $e->getMessage() . " | File: " . $e->getFile() . " | Line: " . $e->getLine());
    http_response_code(500);
    echo json_encode(["success" => false, "error" => "Failed to release funds: " . $e->getMessage()]);
} catch (Error $e) {
    $conn->rollback();
    error_log("Release escrow fatal error: " . $e->getMessage() . " | File: " . $e->getFile() . " | Line: " . $e->getLine());
    http_response_code(500);
    echo json_encode(["success" => false, "error" => "Failed to release funds: " . $e->getMessage()]);
}

if (isset($conn) && $conn) {
    $conn->close();
}
if (isset($transactions_conn) && $transactions_conn && !$transactions_conn->connect_error) {
    $transactions_conn->close();
}
?>
