<?php
require_once __DIR__ . '/../config/database.php';

// $input = json_decode(file_get_contents('php://input'), true);
// $userId = $input['userId'];
// $rating = (int)$input['rating']; // 1 to 5

// // For simplicity, just average all ratings (you can normalize later)
// $stmt = $pdo->prepare("INSERT INTO ratings (user_id, rating) VALUES (?, ?)");
// $stmt->execute([$userId, $rating]);

// // Update avg rating
// $stmt = $pdo->prepare("SELECT AVG(rating) as avg_rating FROM ratings WHERE user_id = ?");
// $stmt->execute([$userId]);
// $avg = round($stmt->fetch(PDO::FETCH_ASSOC)['avg_rating'], 2);

// $pdo->prepare("UPDATE users SET rating = ? WHERE id = ?")
//     ->execute([$avg, $userId]);

// echo json_encode(['success' => true, 'new_rating' => $avg]);

// <?php
// rate_user.php
// require 'db.php';

$data = json_decode(file_get_contents('php://input'), true);
$tradeId = $data['trade_id'];
$raterId = $data['rater_id'];
$ratedUserId = $data['rated_user_id'];
$rating = (int)$data['rating'];
$comment = isset($data['comment']) ? trim($data['comment']) : '';

// Validate rating is between 1 and 5
if ($rating < 1 || $rating > 5) {
    echo json_encode(['success' => false, 'error' => 'Rating must be between 1 and 5']);
    exit;
}

// Validate comment length (max 500 characters)
if (strlen($comment) > 500) {
    echo json_encode(['success' => false, 'error' => 'Comment must be 500 characters or less']);
    exit;
}

// Check if rating already exists for this trade and rater
$checkStmt = $pdo->prepare("SELECT id, rating, comment FROM ratings WHERE trade_id = ? AND rater_id = ?");
$checkStmt->execute([$tradeId, $raterId]);
$existingRating = $checkStmt->fetch();

if ($existingRating) {
    // Update existing rating
    $updateStmt = $pdo->prepare("UPDATE ratings SET rating = ?, comment = ?, created_at = NOW() WHERE trade_id = ? AND rater_id = ?");
    $updateStmt->execute([$rating, $comment ? $comment : null, $tradeId, $raterId]);
} else {
    // Insert new rating
    $stmt = $pdo->prepare("INSERT INTO ratings (trade_id, rater_id, rated_user_id, rating, comment, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
    $stmt->execute([$tradeId, $raterId, $ratedUserId, $rating, $comment ? $comment : null]);
}

// Update user reputation average based on ratings received
$updateStmt = $pdo->prepare("
  UPDATE users u 
  SET rating = (
    SELECT COALESCE(ROUND(AVG(rating), 1), 5.0) 
    FROM ratings 
    WHERE rated_user_id = u.id
  )
  WHERE id = ?
");
$updateStmt->execute([$ratedUserId]);

// Get updated rating
$ratingStmt = $pdo->prepare("SELECT rating FROM users WHERE id = ?");
$ratingStmt->execute([$ratedUserId]);
$newRating = $ratingStmt->fetchColumn();

echo json_encode([
  'success' => true,
  'message' => 'Rating submitted successfully',
  'new_rating' => (float)$newRating
]);
?>
