<?php
/**
 * Migration script to update trades table status ENUM
 * Run this once to update the database schema to support 'pending' status
 */

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$response = ["success" => false, "message" => ""];

try {
    // Database connection
    $conn = new mysqli("localhost","coinfzbe_pro_user", "_xS89yo#g?Rv", "coinfzbe_vortexprp");
    
    if ($conn->connect_error) {
        $response["message"] = "Database connection failed: " . $conn->connect_error;
        echo json_encode($response);
        exit;
    }

    // Check current ENUM values
    $result = $conn->query("SHOW COLUMNS FROM trades WHERE Field = 'status'");
    
    if (!$result) {
        $response["message"] = "Failed to check trades table structure. Error: " . $conn->error;
        echo json_encode($response);
        exit;
    }

    $row = $result->fetch_assoc();
    $currentType = $row['Type'];
    
    echo "Current status ENUM: " . $currentType . "\n\n";
    
    // Check if 'pending' is already in the ENUM
    if (strpos($currentType, "'pending'") !== false) {
        $response["success"] = true;
        $response["message"] = "Schema already updated. 'pending' status is available.";
        echo json_encode($response, JSON_PRETTY_PRINT);
        exit;
    }

    // Update the ENUM to include pending and waiting_seller
    echo "Updating status ENUM...\n";
    
    $alterQuery = "ALTER TABLE trades 
        MODIFY COLUMN status ENUM('pending', 'waiting_seller', 'active', 'completed', 'cancelled', 'disputed') DEFAULT 'pending'";
    
    if ($conn->query($alterQuery)) {
        $response["success"] = true;
        $response["message"] = "Status ENUM updated successfully! Added: 'pending', 'waiting_seller'";
        
        // Verify the update
        $verifyResult = $conn->query("SHOW COLUMNS FROM trades WHERE Field = 'status'");
        $verifyRow = $verifyResult->fetch_assoc();
        $response["new_status_enum"] = $verifyRow['Type'];
        
        echo "\n✅ Migration successful!\n";
        echo "New status ENUM: " . $verifyRow['Type'] . "\n";
        echo json_encode($response, JSON_PRETTY_PRINT);
    } else {
        $response["message"] = "Failed to update status ENUM: " . $conn->error;
        echo "\n❌ Migration failed!\n";
        echo "Error: " . $conn->error . "\n";
        echo json_encode($response, JSON_PRETTY_PRINT);
    }

    $conn->close();
    
} catch (Exception $e) {
    $response["message"] = "Unexpected error: " . $e->getMessage();
    echo "\n❌ Error: " . $e->getMessage() . "\n";
    echo json_encode($response, JSON_PRETTY_PRINT);
}
?>

