-- Simple migration script (alternative - run these one by one if the above doesn't work)
-- This version will error if columns already exist, but is simpler

-- Add admin_id column
ALTER TABLE trades ADD COLUMN admin_id INT NULL COMMENT 'Admin user ID if admin has joined the chat';

-- Add dispute columns
ALTER TABLE trades ADD COLUMN dispute_reason TEXT NULL COMMENT 'Reason for dispute/report';
ALTER TABLE trades ADD COLUMN reported_by INT NULL COMMENT 'User ID who reported/disputed the trade';
ALTER TABLE trades ADD COLUMN reported_at TIMESTAMP NULL COMMENT 'When the trade was reported';

-- Add admin joined timestamp
ALTER TABLE trades ADD COLUMN admin_joined_at TIMESTAMP NULL COMMENT 'When admin joined the chat';

-- Add cancellation columns
ALTER TABLE trades ADD COLUMN cancelled_by INT NULL COMMENT 'User ID who cancelled the trade';
ALTER TABLE trades ADD COLUMN cancelled_at TIMESTAMP NULL COMMENT 'When the trade was cancelled';

-- Add indexes
CREATE INDEX idx_admin_trades ON trades (admin_id);
CREATE INDEX idx_disputed_trades ON trades (reported_by, reported_at);
CREATE INDEX idx_cancelled_trades ON trades (cancelled_by, cancelled_at);

-- Update status ENUM to include 'disputed'
ALTER TABLE trades MODIFY COLUMN status ENUM('pending', 'waiting_seller', 'active', 'completed', 'cancelled', 'disputed') DEFAULT 'pending';

