-- Migration script to add admin, dispute, and cancellation features to trades table
-- Run this to add the necessary columns for admin support and dispute resolution

-- Add columns one by one (MySQL doesn't support IF NOT EXISTS in ALTER TABLE)
SET @dbname = DATABASE();
SET @tablename = 'trades';
SET @preparedStatement = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
   WHERE TABLE_SCHEMA = @dbname 
   AND TABLE_NAME = @tablename 
   AND COLUMN_NAME = 'admin_id') > 0,
  'SELECT 1',
  'ALTER TABLE trades ADD COLUMN admin_id INT NULL COMMENT ''Admin user ID if admin has joined the chat'''
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

SET @preparedStatement = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
   WHERE TABLE_SCHEMA = @dbname 
   AND TABLE_NAME = @tablename 
   AND COLUMN_NAME = 'dispute_reason') > 0,
  'SELECT 1',
  'ALTER TABLE trades ADD COLUMN dispute_reason TEXT NULL COMMENT ''Reason for dispute/report'''
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

SET @preparedStatement = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
   WHERE TABLE_SCHEMA = @dbname 
   AND TABLE_NAME = @tablename 
   AND COLUMN_NAME = 'reported_by') > 0,
  'SELECT 1',
  'ALTER TABLE trades ADD COLUMN reported_by INT NULL COMMENT ''User ID who reported/disputed the trade'''
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

SET @preparedStatement = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
   WHERE TABLE_SCHEMA = @dbname 
   AND TABLE_NAME = @tablename 
   AND COLUMN_NAME = 'reported_at') > 0,
  'SELECT 1',
  'ALTER TABLE trades ADD COLUMN reported_at TIMESTAMP NULL COMMENT ''When the trade was reported'''
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

SET @preparedStatement = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
   WHERE TABLE_SCHEMA = @dbname 
   AND TABLE_NAME = @tablename 
   AND COLUMN_NAME = 'admin_joined_at') > 0,
  'SELECT 1',
  'ALTER TABLE trades ADD COLUMN admin_joined_at TIMESTAMP NULL COMMENT ''When admin joined the chat'''
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

SET @preparedStatement = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
   WHERE TABLE_SCHEMA = @dbname 
   AND TABLE_NAME = @tablename 
   AND COLUMN_NAME = 'cancelled_by') > 0,
  'SELECT 1',
  'ALTER TABLE trades ADD COLUMN cancelled_by INT NULL COMMENT ''User ID who cancelled the trade'''
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

SET @preparedStatement = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
   WHERE TABLE_SCHEMA = @dbname 
   AND TABLE_NAME = @tablename 
   AND COLUMN_NAME = 'cancelled_at') > 0,
  'SELECT 1',
  'ALTER TABLE trades ADD COLUMN cancelled_at TIMESTAMP NULL COMMENT ''When the trade was cancelled'''
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add indexes if they don't exist
SET @indexExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS 
  WHERE TABLE_SCHEMA = @dbname 
  AND TABLE_NAME = @tablename 
  AND INDEX_NAME = 'idx_admin_trades');
SET @sql = IF(@indexExists = 0, 
  'CREATE INDEX idx_admin_trades ON trades (admin_id)', 
  'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @indexExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS 
  WHERE TABLE_SCHEMA = @dbname 
  AND TABLE_NAME = @tablename 
  AND INDEX_NAME = 'idx_disputed_trades');
SET @sql = IF(@indexExists = 0, 
  'CREATE INDEX idx_disputed_trades ON trades (reported_by, reported_at)', 
  'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @indexExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS 
  WHERE TABLE_SCHEMA = @dbname 
  AND TABLE_NAME = @tablename 
  AND INDEX_NAME = 'idx_cancelled_trades');
SET @sql = IF(@indexExists = 0, 
  'CREATE INDEX idx_cancelled_trades ON trades (cancelled_by, cancelled_at)', 
  'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Update status ENUM to include 'disputed' if not already present
-- Check current ENUM values first
SET @enumCheck = (SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS 
  WHERE TABLE_SCHEMA = @dbname 
  AND TABLE_NAME = @tablename 
  AND COLUMN_NAME = 'status');
SET @hasDisputed = (SELECT @enumCheck LIKE '%disputed%');
SET @sql = IF(@hasDisputed = 0, 
  'ALTER TABLE trades MODIFY COLUMN status ENUM(''pending'', ''waiting_seller'', ''active'', ''completed'', ''cancelled'', ''disputed'') DEFAULT ''pending''', 
  'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SELECT 'Trades table updated successfully with admin, dispute, and cancellation features!' as Status;

