<?php
// require '../config.php'; // Make sure DB connection is loaded
require_once __DIR__ . '/../config/database.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents("php://input"), true);
$user_iddd = isset($input['user_id']) ? intval($input['user_id']) : 0;
// $user_id = $_GET['user_id'];
$user_id = $input['user_id'];
// echo $user_id;
// echo $user_id;
if (!$user_id) {
    echo json_encode(['error' => 'Missing user_id']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT t.*, 
               u1.username AS buyer_name, 
               u2.username AS seller_name 
        FROM trades t
        LEFT JOIN users u1 ON t.buyer_id = u1.id
        LEFT JOIN users u2 ON t.seller_id = u2.id
        WHERE t.buyer_id = :user_id OR t.seller_id = :user_id
        ORDER BY t.created_at DESC
    ");
    $stmt->execute(['user_id' => $user_id]);
    $trades = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($trades);

} catch (Exception $e) {
    echo json_encode(['error' => 'DB error: ' . $e->getMessage()]);
}
