<?php
// require '../config.php'; // Make sure this sets up $pdo
require_once __DIR__ . '/../config/database.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents("php://input"), true);
$user_id = isset($input['user_id']) ? intval($input['user_id']) : 0;

if (!$user_id) {
    echo json_encode(['error' => 'Missing user_id']);
    exit;
}

try {
    // Get total trades
    $stmtTotal = $pdo->prepare("SELECT COUNT(*) FROM trades WHERE buyer_id = :user_id OR seller_id = :user_id");
    $stmtTotal->execute(['user_id' => $user_id]);
    $total_trades = (int) $stmtTotal->fetchColumn();

    // Get completed trades
    $stmtCompleted = $pdo->prepare("SELECT COUNT(*) FROM trades WHERE (buyer_id = :user_id OR seller_id = :user_id) AND status = 'completed'");
    $stmtCompleted->execute(['user_id' => $user_id]);
    $completed_trades = (int) $stmtCompleted->fetchColumn();

    // Get average rating
    $stmtRating = $pdo->prepare("SELECT AVG(rating) FROM ratings WHERE rated_user_id = :user_id");
    $stmtRating->execute(['user_id' => $user_id]);
    $avg_rating = round(floatval($stmtRating->fetchColumn()), 2);

    // Success rate
    $success_rate = $total_trades > 0 ? round(($completed_trades / $total_trades) * 100, 2) : 0;

    echo json_encode([
        'user_id' => $user_id,
        'total_trades' => $total_trades,
        'completed_trades' => $completed_trades,
        'avg_rating' => $avg_rating,
        'success_rate' => $success_rate
    ]);

} catch (Exception $e) {
    echo json_encode(['error' => 'DB error: ' . $e->getMessage()]);
}
