<?php
// require '../config.php'; // Ensure this includes your DB connection
require_once __DIR__ . '/../config/database.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents("php://input"), true);
$user_iddd = isset($input['user_id']) ? intval($input['user_id']) : 0;
// $user_id = $_GET['user_id'];
$user_id = $input['user_id'];
if (!$user_id) {
    echo json_encode(['error' => 'Missing user_id']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT id, coin, currency, amount, price_per_unit, country, trade_type, status, created_at
        FROM listings
        WHERE seller_id = :user_id
        ORDER BY created_at DESC
    ");
    $stmt->execute(['user_id' => $user_id]);
    $listings = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($listings);

} catch (Exception $e) {
    echo json_encode(['error' => 'DB error: ' . $e->getMessage()]);
}
