<?php
require_once __DIR__ . '/../config/database.php';
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $tradeId = $_GET['tradeId'];
    $stmt = $pdo->prepare("SELECT * FROM chat WHERE trade_id = ? ORDER BY created_at ASC");
    $stmt->execute([$tradeId]);
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));

} elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $stmt = $pdo->prepare("INSERT INTO chat (trade_id, sender_id, message) VALUES (?, ?, ?)");
    $stmt->execute([
        $input['trade_id'],
        $input['sender_id'],
        $input['message']
    ]);
    echo json_encode(['success' => true]);
}
