<?php
$timeout_minutes = 60;
$db->query("
  UPDATE trades 
  SET status = 'cancelled'
  WHERE status = 'active'
    AND TIMESTAMPDIFF(MINUTE, created_at, NOW()) > $timeout_minutes
");

// Refund seller's escrow
$trades = $db->query("
  SELECT t.id, l.seller_id, l.amount, l.currency 
  FROM trades t 
  JOIN listings l ON t.listing_id = l.id 
  WHERE t.status = 'cancelled'
");

while ($t = $trades->fetch_assoc()) {
  $seller = $t['seller_id'];
  $amount = $t['amount'];
  $currency = $t['currency'];
  $db->query("UPDATE users SET escrow_$currency = escrow_$currency - $amount, balance_$currency = balance_$currency + $amount WHERE id = $seller");
}
// add cronjob */5 * * * * php /var/www/html/auto_cancel_trades.php to run every 5 minites
