<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'vendor/autoload.php';
use Slim\Factory\AppFactory;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use GuzzleHttp\Client;

$app = AppFactory::create();
$db = new PDO("mysql:host=127.0.0.1;dbname=vortex", "root", ""); // Changed to 127.0.0.1
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// CORS Middleware
$app->add(function (Request $request, $handler) {
    $response = $handler->handle($request);
    return $response
        ->withHeader('Access-Control-Allow-Origin', 'http://localhost:5173')
        ->withHeader('Access-Control-Allow-Headers', 'Content-Type, Authorization')
        ->withHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS');
});

$app->options('/{routes:.+}', function (Request $request, Response $response) {
    return $response;
});

$app->post('/create-address', function (Request $request, Response $response) use ($db) {
    try {
        $data = json_decode($request->getBody()->getContents(), true);
        $username = $data['username'] ?? '';
        if (empty($username)) throw new Exception("Username is required");

        $stmt = $db->prepare("SELECT wallet_address FROM users WHERE username = ?");
        $stmt->execute([$username]);
        if ($stmt->fetchColumn()) throw new Exception("Username already exists");

        $client = new Client();
        $res = $client->post('http://localhost:3001/generate-address');
        $result = json_decode($res->getBody()->getContents(), true);

        $stmt = $db->prepare("INSERT INTO users (username, wallet_address, private_key) VALUES (?, ?, ?)");
        $stmt->execute([$username, $result['address'], $result['privateKey']]);

        $response->getBody()->write(json_encode(['address' => $result['address']]));
    } catch (Exception $e) {
        $response = $response->withStatus(400);
        $response->getBody()->write(json_encode(['error' => $e->getMessage()]));
    }
    return $response->withHeader('Content-Type', 'application/json');
});

$app->post('/record-deposit', function (Request $request, Response $response) use ($db) {
    try {
        $data = json_decode($request->getBody()->getContents(), true);
        error_log("Received payload: " . print_r($data, true));

        $username = $data['username'] ?? '';
        $amount = $data['amount'] ?? 0;
        $tokenMint = $data['tokenMint'] ?? null;
        $signature = $data['signature'] ?? '';
        if (empty($username) || $amount <= 0 || empty($signature)) {
            throw new Exception("Missing required fields: username=$username, amount=$amount, signature=$signature");
        }

        $stmt = $db->prepare("SELECT id, wallet_address FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$user) throw new Exception("User not found: $username");

        $tokenName = $tokenMint ? ($tokenMint === 'EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v' ? 'USDC' : 'Unknown') : 'SOL';
        $tokenTicker = strtoupper($tokenName);

        // Save to deposits table
        $stmt = $db->prepare(
            "INSERT INTO deposits (user_id, wallet_address, amount, token_mint, token_name, timestamp, signature) 
            VALUES (?, ?, ?, ?, ?, NOW(), ?)"
        );
        $stmt->execute([$user['id'], $user['wallet_address'], $amount, $tokenMint, $tokenName, $signature]);

        // Save to transactions table (vortex database)
        function generateRandomString($length = 17) {
            $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $charactersLength = strlen($characters);
            $randomString = '';
            for ($i = 0; $i < $length; $i++) {
                $randomString .= 'URI'.$characters[random_int(0, $charactersLength - 1)];
            }
            return $randomString;
        }
        $txnid = generateRandomString(13);
        
        try {
            // Connect to vortex database for transactions table
            $transactions_db = new PDO("mysql:host=127.0.0.1;dbname=vortex", "root", "");
            $transactions_db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            $stmt = $transactions_db->prepare(
                "INSERT INTO transactions (username, address, destination, amount, to_amount, status, type, coin, cointicker, txtype, txnid, fee)
                VALUES (?, ?, ?, ?, ?, 'Completed', 'Received', ?, ?, 'deposit', ?, '0.00000')"
            );
            $stmt->execute([
                $username,
                $user['wallet_address'],
                'deposit',
                $amount,
                $amount,
                $tokenName,
                $tokenTicker,
                $signature // Use signature as txnid if available, otherwise use generated one
            ]);
            
            // Send real-time notification
            require_once __DIR__ . '/crispapi/notification_helper.php';
            $userId = $user['id'] ?? null;
            if ($userId) {
                sendNotification($userId, $username, [
                    'type' => 'transaction',
                    'title' => 'Deposit Received',
                    'message' => "You received {$amount} {$tokenTicker}",
                    'data' => [
                        'type' => 'deposit',
                        'amount' => $amount,
                        'coin' => $tokenTicker,
                        'status' => 'Completed',
                        'txnid' => $signature,
                    ],
                    'timestamp' => date('c'),
                ]);
            }
        } catch (PDOException $e) {
            // If transactions table doesn't exist in this database, log but don't fail
            error_log("Could not save to transactions table: " . $e->getMessage());
        }

        $response->getBody()->write(json_encode(['status' => 'Deposit recorded']));
    } catch (Exception $e) {
        error_log("Error in /record-deposit: " . $e->getMessage());
        $response = $response->withStatus(400);
        $response->getBody()->write(json_encode(['error' => $e->getMessage()]));
    }
    return $response->withHeader('Content-Type', 'application/json');
});

$app->get('/deposits', function (Request $request, Response $response) use ($db) {
    $username = $request->getQueryParams()['username'] ?? '';
    $stmt = $db->prepare("SELECT d.* FROM deposits d JOIN users u ON d.user_id = u.id WHERE u.username = ?");
    $stmt->execute([$username]);
    $deposits = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $response->getBody()->write(json_encode($deposits));
    return $response->withHeader('Content-Type', 'application/json');
});

$app->run();